set autoscale 
set xtic auto
set ytic auto 
set style line  1 lt 1 lw 1 lc rgb "#FF0000"
set style line  2 lt 1 lw 1 lc rgb "#0000FF"

set xlabel "E (eV)" font "Times,12"
set ylabel "Intensity (arb. units)" font "Times,12"

set out 'Temperature.ps'
set size 1.0, 1.0
set terminal postscript portrait enhanced color  "Times" 8

plot "TemperatureXASSpecIso.dat"  u 1:(-$3) title 'Iso ' with lines ls  1,\
     "TemperatureXASSpecXMCD.dat" u 1:(-$3) title 'XMCD' with lines ls  2

